import BaseStyle from '@primevue/core/base/style';

var theme = function theme(_ref) {
  var dt = _ref.dt;
  return "\n.p-checkbox {\n    position: relative;\n    display: inline-flex;\n    user-select: none;\n    vertical-align: bottom;\n    width: ".concat(dt('checkbox.width'), ";\n    height: ").concat(dt('checkbox.height'), ";\n}\n\n.p-checkbox-input {\n    cursor: pointer;\n    appearance: none;\n    position: absolute;\n    top: 0;\n    left: 0;\n    width: 100%;\n    height: 100%;\n    padding: 0;\n    margin: 0;\n    opacity: 0;\n    z-index: 1;\n    outline: 0 none;\n    border: 1px solid transparent;\n    border-radius: ").concat(dt('checkbox.border.radius'), ";\n}\n\n.p-checkbox-box {\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    border-radius: ").concat(dt('checkbox.border.radius'), ";\n    border: 1px solid ").concat(dt('checkbox.border.color'), ";\n    background: ").concat(dt('checkbox.background'), ";\n    width: ").concat(dt('checkbox.width'), ";\n    height: ").concat(dt('checkbox.height'), ";\n    transition: background ").concat(dt('checkbox.transition.duration'), ", color ").concat(dt('checkbox.transition.duration'), ", border-color ").concat(dt('checkbox.transition.duration'), ", box-shadow ").concat(dt('checkbox.transition.duration'), ", outline-color ").concat(dt('checkbox.transition.duration'), ";\n    outline-color: transparent;\n    box-shadow: ").concat(dt('checkbox.shadow'), ";\n}\n\n.p-checkbox-icon {\n    transition-duration: ").concat(dt('checkbox.transition.duration'), ";\n    color: ").concat(dt('checkbox.icon.color'), ";\n    font-size: ").concat(dt('checkbox.icon.size'), ";\n    width: ").concat(dt('checkbox.icon.size'), ";\n    height: ").concat(dt('checkbox.icon.size'), ";\n}\n\n.p-checkbox:not(.p-disabled):has(.p-checkbox-input:hover) .p-checkbox-box {\n    border-color: ").concat(dt('checkbox.hover.border.color'), ";\n}\n\n.p-checkbox-checked .p-checkbox-box {\n    border-color: ").concat(dt('checkbox.checked.border.color'), ";\n    background: ").concat(dt('checkbox.checked.background'), ";\n}\n\n.p-checkbox-checked .p-checkbox-icon {\n    color: ").concat(dt('checkbox.icon.checked.color'), ";\n}\n\n.p-checkbox-checked:not(.p-disabled):has(.p-checkbox-input:hover) .p-checkbox-box {\n    background: ").concat(dt('checkbox.checked.hover.background'), ";\n    border-color: ").concat(dt('checkbox.checked.hover.border.color'), ";\n}\n\n.p-checkbox-checked:not(.p-disabled):has(.p-checkbox-input:hover) .p-checkbox-icon {\n    color: ").concat(dt('checkbox.icon.checked.hover.color'), ";\n}\n\n.p-checkbox:not(.p-disabled):has(.p-checkbox-input:focus-visible) .p-checkbox-box {\n    border-color: ").concat(dt('checkbox.focus.border.color'), ";\n    box-shadow: ").concat(dt('checkbox.focus.ring.shadow'), ";\n    outline: ").concat(dt('checkbox.focus.ring.width'), " ").concat(dt('checkbox.focus.ring.style'), " ").concat(dt('checkbox.focus.ring.color'), ";\n    outline-offset: ").concat(dt('checkbox.focus.ring.offset'), ";\n}\n\n.p-checkbox-checked:not(.p-disabled):has(.p-checkbox-input:focus-visible) .p-checkbox-box {\n    border-color: ").concat(dt('checkbox.checked.focus.border.color'), ";\n}\n\n.p-checkbox.p-invalid > .p-checkbox-box {\n    border-color: ").concat(dt('checkbox.invalid.border.color'), ";\n}\n\n.p-checkbox.p-variant-filled .p-checkbox-box {\n    background: ").concat(dt('checkbox.filled.background'), ";\n}\n\n.p-checkbox-checked.p-variant-filled .p-checkbox-box {\n    background: ").concat(dt('checkbox.checked.background'), ";\n}\n\n.p-checkbox-checked.p-variant-filled:not(.p-disabled):has(.p-checkbox-input:hover) .p-checkbox-box {\n    background: ").concat(dt('checkbox.checked.hover.background'), ";\n}\n\n.p-checkbox.p-disabled {\n    opacity: 1;\n}\n\n.p-checkbox.p-disabled .p-checkbox-box {\n    background: ").concat(dt('checkbox.disabled.background'), ";\n    border-color: ").concat(dt('checkbox.checked.disabled.border.color'), ";\n}\n\n.p-checkbox.p-disabled .p-checkbox-box .p-checkbox-icon {\n    color: ").concat(dt('checkbox.icon.disabled.color'), ";\n}\n");
};
var classes = {
  root: function root(_ref2) {
    var instance = _ref2.instance,
      props = _ref2.props;
    return ['p-checkbox p-component', {
      'p-checkbox-checked': instance.checked,
      'p-disabled': props.disabled,
      'p-invalid': props.invalid,
      'p-variant-filled': props.variant ? props.variant === 'filled' : instance.$primevue.config.inputStyle === 'filled' || instance.$primevue.config.inputVariant === 'filled'
    }];
  },
  box: 'p-checkbox-box',
  input: 'p-checkbox-input',
  icon: 'p-checkbox-icon'
};
var CheckboxStyle = BaseStyle.extend({
  name: 'checkbox',
  theme: theme,
  classes: classes
});

export { CheckboxStyle as default };
//# sourceMappingURL=index.mjs.map
