import AppLayout from '@/layout/AppLayout.vue';
import { createRouter, createWebHistory } from 'vue-router';

const router = createRouter({
    history: createWebHistory(import.meta.env.BASE_URL),
    routes: [
        {
            path: '/dashboard',
            component: AppLayout,
            meta: {
                requiresAuth: true // Add meta field to indicate protected route
            },
            children: [
                {
                    path: '/dashboard',
                    name: 'dashboard',
                    component: () => import('@/views/Dashboard.vue')
                },
                {
                    path: '/pages/empty',
                    name: 'empty',
                    component: () => import('@/views/pages/Empty.vue')
                },
                {
                    path: '/pages/surat/add/:id',
                    component: () => import('@/views/pages/DispenNikah1.vue')
                },
                {
                    path: '/pages/surat/list/:id',
                    component: () => import('@/views/pages/DispenNikahList.vue')
                },
                {
                    path: '/pages/upload/:id/:final',
                    name: 'upload',
                    component: () => import('@/views/pages/UploadFile.vue')
                }
            ]
        },
        {
            path: '/pages/notfound',
            name: 'notfound',
            component: () => import('@/views/pages/NotFound.vue')
        },
        {
            path: '/',
            name: 'login',
            component: () => import('@/views/pages/auth/Login.vue')
        },
        {
            path: '/auth/register',
            name: 'register',
            component: () => import('@/views/pages/auth/Register.vue')
        },
        {
            path: '/auth/access',
            name: 'accessDenied',
            component: () => import('@/views/pages/auth/Access.vue')
        },
        {
            path: '/auth/error',
            name: 'error',
            component: () => import('@/views/pages/auth/Error.vue')
        }
    ]
});
// router.beforeEach((to, from, next) => {
//     if (!to.matched.length) {
//         next('/pages/notfound');
//     } else {
//         if (to.meta.requiresAuth) {
//             const token = localStorage.getItem('token');
//             if (token) {
//                 // User is authenticated, proceed to the route
//                 next();
//             } else {
//                 // User is not authenticated, redirect to login
//                 next('/');
//             }
//         } else {
//             // Non-protected route, allow access
//             next();
//         }
//     }
// });

export default router;
